import bpy

class GEO_OT_rename_meshes(bpy.types.Operator):
    bl_idname = "geo.rename_meshes"
    bl_label = "Rename Meshes"
    bl_description = "Rename all mesh data blocks to match their object names"

    def execute(self, context):
        renamed = 0
        for obj in context.scene.objects:
            if obj.type == 'MESH':
                old_name = obj.data.name
                obj.data.name = f"{obj.name}Mesh"
                renamed += 1
        self.report({'INFO'}, f"Renamed {renamed} meshes")
        return {'FINISHED'}


# Register/unregister helpers
def register():
    bpy.utils.register_class(GEO_OT_rename_meshes)

def unregister():
    bpy.utils.unregister_class(GEO_OT_rename_meshes)
